﻿* Encoding: UTF-8.
*create a new dataset without Attribute-3European=0.
DATASET COPY  Survey2_Tables_attr3.
DATASET ACTIVATE Survey2_Tables_attr3.
FILTER OFF.
USE ALL.
SELECT IF (attribute_3European ~= 1).
EXECUTE.
***************************************************************************.
* Table 2 (for B2)

USE ALL.
COMPUTE filter_$=(survey=2).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

FREQUENCIES VARIABLES=category
  /ORDER=ANALYSIS.

* Table 3 (item nonresponse).
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 2-6.
CTABLES
  /VLABELS VARIABLES=nmisp2 nmisp3 nmisp4 nmisp5 nmisp6 survey DISPLAY=LABEL
  /TABLE nmisp2 [VALIDN F40.0, MEAN, MEDIAN] + nmisp3 [VALIDN F40.0, MEAN, MEDIAN] + nmisp4 [VALIDN 
    F40.0, MEAN, MEDIAN] + nmisp5 [VALIDN F40.0, MEAN, MEDIAN] + nmisp6 [VALIDN F40.0, MEAN, MEDIAN] BY 
    survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= nmisp2 nmisp3 nmisp4 nmisp5 nmisp6 BY survey(1 2)
  /MISSING ANALYSIS.

* Table 4 (mid-point).
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 2.
CTABLES
  /VLABELS VARIABLES=C8pop2ratio3 survey DISPLAY=LABEL
  /TABLE C8pop2ratio3 [S][VALIDN F40.0, MEAN, MEDIAN]  BY survey [C]
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.


NPAR TESTS
  /M-W= C8pop2ratio3 BY survey(1 2)
  /MISSING ANALYSIS.

*section 3.
CTABLES
  /VLABELS VARIABLES=D5ratio3 survey DISPLAY=LABEL
  /TABLE D5ratio3 [S][VALIDN F40.0, MEAN, MEDIAN]  BY survey [C]
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.


NPAR TESTS
  /M-W= D5ratio3 BY survey(1 2)
  /MISSING ANALYSIS.

*Table 5 (speeders).
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 2-3.
CTABLES
  /VLABELS VARIABLES=meanflag2 meanflag3 survey DISPLAY=LABEL
  /TABLE meanflag2 [VALIDN F40.0, MEAN, MEDIAN] + meanflag3 [VALIDN F40.0, MEAN, MEDIAN]  BY survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= meanflag2 meanflag3  BY survey(1 2)
  /MISSING ANALYSIS.

*Table 6 (Straight lining) .
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 2-3.

CTABLES
  /VLABELS VARIABLES=slm2, slm3 survey DISPLAY=LABEL
  /TABLE slm2 [VALIDN F40.0, MEAN, MEDIAN] + slm3 [VALIDN F40.0, MEAN, MEDIAN]  BY 
    survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= slm2, slm3 BY survey(1 2)
  /MISSING ANALYSIS.

*Table 7 (open-ended).
*open-ended1.
USE ALL.
COMPUTE filter_$=(lengthc1 > 0 & category = 1).
VARIABLE LABELS filter_$ 'lengthc1 > 0 & category = 1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=lengthc1 survey DISPLAY=LABEL
  /TABLE lengthc1 [VALIDN F40.0, MEAN, MEDIAN]  BY 
    survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= lengthc1 BY survey(1 2)
  /MISSING ANALYSIS.

*open-ended2.

USE ALL.
COMPUTE filter_$=(lengthe15 > 0 & category = 1).
VARIABLE LABELS filter_$ 'lengthe15 > 0 & category = 1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

CTABLES
  /VLABELS VARIABLES=lengthe15 survey DISPLAY=LABEL
  /TABLE lengthe15 [VALIDN F40.0, MEAN, MEDIAN]  BY 
    survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= lengthe15 BY survey(1 2)
  /MISSING ANALYSIS.

